/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.its.asn1;

import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.its.asn1.Utils;
import org.bouncycastle.util.Arrays;

public class LinkageValue
extends ASN1Object {
    private final byte[] value;

    private LinkageValue(ASN1OctetString octs) {
        this.value = Arrays.clone(Utils.octetStringFixed(octs.getOctets(), 9));
    }

    public static LinkageValue getInstance(Object src) {
        if (src instanceof LinkageValue) {
            return (LinkageValue)src;
        }
        if (src != null) {
            return new LinkageValue(ASN1OctetString.getInstance(src));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DEROctetString(Arrays.clone(this.value));
    }
}

