/*
 * Decompiled with CFR 0.152.
 */
package com.android.signapk;

import java.io.IOException;
import java.io.OutputStream;

class CountingOutputStream
extends OutputStream {
    private final OutputStream mBase;
    private long mWrittenBytes;

    public CountingOutputStream(OutputStream base) {
        this.mBase = base;
    }

    @Override
    public void close() throws IOException {
        this.mBase.close();
    }

    @Override
    public void flush() throws IOException {
        this.mBase.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mBase.write(b);
        this.mWrittenBytes += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mBase.write(b, off, len);
        this.mWrittenBytes += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.mBase.write(b);
        ++this.mWrittenBytes;
    }

    public long getWrittenBytes() {
        return this.mWrittenBytes;
    }
}

